//Listing 17.5 Przykad klasy szablonu z zagniedon klas serwera
#include <iostream>
using namespace std;

template <class T>
class Stack {
     struct Node { // zaley od typu parametru
        T item; // ten sam typ co w Stack
        Node *next; // Node<T> jest w tym miejscu niepoprawny
        Node(const T& val) : item(val) // ten sam typ co w Stack
        { next = NULL; } } ;
  Node *top; // teraz nie jest to szablon
public:
  Stack()// warto domylna: brak pocztkowego rozmiaru
  { top = NULL; }
  void push(const T&);
  T pop();
  int isEmpty() const
  { return top == NULL; } // czy warto top wskazuje wze?
  ~Stack();
} ;

template <class T>
void Stack<T>::push (const T& val)
// { Node<T> *p = new Node<T>(val); // typ Node<T>, a nie Node
  { Node *p = new Node(val); // typ Node, a nie Node<T>
    if (p == NULL)
      { cout << "Brak pamici\n"; exit(1); }
    p->next = top; // wskazuje na pierwszy wze
    top = p; } // wskazuje na nowy wze

template <class T>
T Stack<T>::pop() // zwraca warto typu T
// { Node<T> *p = top; // typ Node<T>, a nie Node
  { Node *p = top; // typ Node, a nie Node<T>
    T val = top->item; // pobiera warto typu T
    top = top->next; // wskazuje na drugi wze
    delete p; // zwalnia obszar sterty zajmowany przez najwyszy wze
    return val; }

template <class T>
Stack<T>::~Stack()
// { Node<T> *p = top; // typ Node typu T
  { Node *p = top; // typ Node typu T
    while (top != NULL) // w przypadku braku wzw top ma warto 0
        { top = top->next; // wskazuje na nowy wze
          delete p; // usuwa poprzedni wze
          p = top; } } // przechodzi do kolejnego wza

int main()
{
  int data[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 } ;
  Stack<int> s; // obiekt stosu
  int n = sizeof(data)/sizeof(int); // liczba komponentw
  cout << "Dane pocztkowe: ";
  for (int j = 0; j < n; j++)
    { cout << data[j] << " "; } // wywietla dane wejciowe
  cout << endl;
  for (int i = 0; i < n; i++)
    { s.push(data[i]); } // umieszcza dane na stosie
  cout << "Dane odwrcone: ";
  while (!s.isEmpty()) // zdejmuje dane ze stosu
    cout << s.pop() << " ";
  cout << endl;
  return 0;
}
